﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="BestSellersReport.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Reports.BestSellersReport" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <style>
        .mleft10 {
            margin:10px !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="pageheader">
        <h2>
            <i class="fa fa-money"></i> Best Sellers Report
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Reports.aspx">Reports</a></li>
                <li class="active">Best Sellers Report</li>
            </ol>
        </div>
    </div>

    <div class="main searchFields">
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                From Date :

            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtFromDate" runat="server" CssClass="datepicker" />

            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">To Date :</div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtToDate" runat="server" CssClass="datepicker" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite"></div>
            <div class="col-md-4 col-xs-12">
                <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-lg btn-primary loading" Text="Search"
                    OnClick="btnSearch_Click" />
                &nbsp;&nbsp;&nbsp;
                        <asp:Button ID="btnShowAll" runat="server" CssClass="btn btn-lg btn-primary loading" Text="Show All"
                            OnClick="btnShowAll_Click" />
            </div>
        </div>

    </div>

    <div class="main mleft10">
        <div class="row">
            <div class="col-md-4 col-xs-12">
                <div class="tile-body searchFields">
                    <h4 class="cwhite text-center">Bestsellers - All Time</h4><br />
                    <div id="chBestSellers" style="height: 230px;" class="morris-chart"></div>
                    <ul class="inline text-center chart-legend">
                        <asp:Repeater runat="server" ID="rpBSAllTime">
                            <ItemTemplate>
                                <li><span class="badge badge-outline" style="border-color: #D9544F"></span><%# Eval("ProductName") %> <small>$<%# Eval("TotalSales") %></small>,</li>
                            </ItemTemplate>
                        </asp:Repeater>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 col-xs-12">
                <div class="tile-body searchFields">
                    <h4 class="cwhite text-center">Bestsellers - <asp:Literal ID="lblLastMonth" runat="server" /></h4><br />
                    <div id="chBestSellersLastMonth" style="height: 230px;" class="morris-chart"></div>
                    <ul class="inline text-center chart-legend">
                        <asp:Repeater runat="server" ID="rpBSItemsLastMonth">
                            <ItemTemplate>
                                <li><span class="badge badge-outline" style="border-color: #D9544F"></span><%# Eval("ProductName") %> <small>$<%# Eval("TotalSales") %></small>,</li>
                            </ItemTemplate>
                        </asp:Repeater>
                    </ul>
                </div>
            </div>

            <div class="col-md-4 col-xs-12">
                <div class="tile-body searchFields">
                    <h4 class="cwhite text-center">Bestsellers - <asp:Literal ID="lblCurrentMonth" runat="server" /></h4><br />
                    <div id="chBestSellersCurrentMonth" style="height: 230px;" class="morris-chart"></div>
                    <ul class="inline text-center chart-legend">
                        <asp:Repeater runat="server" ID="rpBSItemCurrentMonth">
                            <ItemTemplate>
                                <li><span class="badge badge-outline" style="border-color: #D9544F"></span><%# Eval("ProductName") %> <small>$<%# Eval("TotalSales") %></small>,</li>
                            </ItemTemplate>
                        </asp:Repeater>
                    </ul>
                </div>
            </div>
        </div>
    </div>



    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Best Seller Report</h1><div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
        </div>
        <div class="tile-body nopadding">
            <div class="responsive-table">
                <asp:GridView runat="server" ID="grdBestSellers" AllowPaging="true" PageSize="30"
                    CssClass="table" Width="98%" GridLines="Both" AutoGenerateColumns="false"
                    OnPageIndexChanging="grdBestSellers_PageIndexChanging">
                    <Columns>
                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                            HeaderText="Sl. No.">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1  %>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Product Name" DataField="ProductName" />
                        <asp:BoundField HeaderText="Qty" DataField="Qty" />
                        <asp:BoundField HeaderText="Total Sales" DataField="TotalSales" DataFormatString="{0:0.00}" />
                    </Columns>
                    <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                        Position="TopAndBottom" />
                    <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None" 
                       Font-Bold="true" Font-Size="Medium" />
                    <HeaderStyle CssClass="tbl-header" />
                    <RowStyle CssClass="tbl-row" />
                    <AlternatingRowStyle CssClass="tbl-row" />
                    <EmptyDataRowStyle />
                    <EmptyDataTemplate>
                        No Record found
                    </EmptyDataTemplate>
                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                </asp:GridView>
            </div>
        </div>
    </section>

      <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script>
        function DrawChart() {
            Morris.Donut({
                element: 'chBestSellers',
                data: [
                    <% for (int i = 0; (bestSellerAllTime != null && i < bestSellerAllTime.Rows.Count); i++)
                       { %>
                    <%= "{ label: '"%><%= bestSellerAllTime.Rows[i]["ProductName"].ToString()%><%="', value:"%><%=bestSellerAllTime.Rows[i]["TotalSales"].ToString()+ " }" %>
                    <% if (i != bestSellerAllTime.Rows.Count - 1)
                       {%>
                    <%=","%>
                    <% }
                       } %>
                ],
                colors: ['#00a3d8', '#2fbbe8', '#72cae7', '#d9544f', '#ffc100', '#1693A5']
            });

            $('#chBestSellers').find("path[stroke='#ffffff']").attr('stroke', 'rgba(0,0,0,0)');

            Morris.Donut({
                element: 'chBestSellersLastMonth',
                data: [
                    <% for (int i = 0; (bestSellerLastMonth != null && i < bestSellerLastMonth.Rows.Count); i++)
                       { %>
                    <%= "{ label: '"%><%= bestSellerLastMonth.Rows[i]["ProductName"].ToString()%><%="', value:"%><%=bestSellerLastMonth.Rows[i]["TotalSales"].ToString()+ " }" %>
                    <% if (i != bestSellerLastMonth.Rows.Count - 1)
                       {%>
                    <%=","%>
                    <% }
                       } %>
                ],
                colors: ['#00a3d8', '#2fbbe8', '#72cae7', '#d9544f', '#ffc100', '#1693A5']
            });

            $('#chBestSellersLastMonth').find("path[stroke='#ffffff']").attr('stroke', 'rgba(0,0,0,0)');

            Morris.Donut({
                element: 'chBestSellersCurrentMonth',
                data: [
                    <% for (int i = 0; (bestSellerCurrentMonth != null && i < bestSellerCurrentMonth.Rows.Count); i++)
                       { %>
                    <%= "{ label: '"%><%= bestSellerCurrentMonth.Rows[i]["ProductName"].ToString()%><%="', value:"%><%=bestSellerCurrentMonth.Rows[i]["TotalSales"].ToString()+ " }" %>
                    <% if (i != bestSellerCurrentMonth.Rows.Count - 1)
                       {%>
                    <%=","%>
                    <% }
                       } %>
                ],
                 colors: ['#00a3d8', '#2fbbe8', '#72cae7', '#d9544f', '#ffc100', '#1693A5']
             });

            $('#chBestSellersCurrentMonth').find("path[stroke='#ffffff']").attr('stroke', 'rgba(0,0,0,0)');
        }
        $(document).ready(function () { DrawChart(); });
        $(window).resize(function () { DrawChart(); });
    </script>
</asp:Content>
